--- @param openCondition CCondition
--- @return CInfos
function NewInfo(openCondition, icon)
	local info = New("CInfos")
	info.openCondition = openCondition
	info.icon = icon
	return info
end

--- @param level CLevel
--- @return CCondition_LevelReached
function NewConditionLevelReached(level)
	local c = New("CCondition_LevelReached")
	c.level = level
	return c
end

local infos = {}

infos.howtoplay = NewInfo(nil, NewCAssetSprite(GItems.defaultIconsFilename, "toggle_info"))
infos.logistics = NewInfo(nil, uiGroups.extraction.icon)

infos.global = NewInfo(nil, NewCAssetSprite(GItems.defaultIconsFilename, "toggle_map"))

infos.trucks = NewInfo(NewConditionLevelReached(levels.level3), NewCAssetSprite(GItems.defaultIconsFilename, items.truck.codeName))
infos.citySupply = NewInfo(NewConditionLevelReached(levels.level3), NewCAssetSprite(GItems.defaultIconsFilename, items.cityIn.codeName))

infos.advancedUI = NewInfo(NewConditionLevelReached(levels.level4), uiGroups.favorites.icon)

infos.selectionAndCopy = NewInfo(NewConditionLevelReached(levels.level4), NewCAssetSprite(GItems.defaultIconsFilename, "SelectionCopy_black"))

infos.terraforming = NewInfo(NewConditionLevelReached(levels.level6), uiGroups.terraforming.icon)
infos.enhancedView = NewInfo(NewConditionLevelReached(levels.level6), NewCAssetSprite(GItems.defaultIconsFilename, "toggle_view"))

infos.recycling = NewInfo(NewConditionLevelReached(levels.level8), NewCAssetSprite(GItems.defaultIconsFilename, items.wasteMetal.codeName))

infos.trains = NewInfo(NewConditionLevelReached(levels.level9), NewCAssetSprite(GItems.defaultIconsFilename, items.train.codeName))

infos.labos = NewInfo(NewConditionLevelReached(levels.level12), NewCAssetSprite(GItems.defaultIconsFilename, items.nanoLab.codeName))
infos.trees = NewInfo(NewConditionLevelReached(levels.level14), uiGroups.plants.icon)
infos.farms = NewInfo(NewConditionLevelReached(levels.level21), NewCAssetSprite(GItems.defaultIconsFilename, items.farm.codeName))
infos.shields = NewInfo(New("CCondition_PopBombed"), NewCAssetSprite(GItems.defaultIconsFilename, items.defenseShield.codeName))

infos.ships = NewInfo(NewConditionLevelReached(levels.level19), NewCAssetSprite(GItems.defaultIconsFilename, items.containerShip.codeName))


GGame.infos = CreateLuaEntityList("CInfos", infos)
